#!/usr/bin/env python3

"""Config system (based on Detectron's)."""

from fvcore.common.config import CfgNode as _CfgNode
from .file_io import PathManager


class CfgNode(_CfgNode):
    """
    The same as `fvcore.common.config.CfgNode`, but different in:

    support manifold path
    """

    @classmethod
    def _open_cfg(cls, filename):
        return PathManager.open(filename, "r")

    def dump(self, *args, **kwargs):
        """
        Returns:
            str: a yaml string representation of the config
        """
        # to make it show up in docs
        return super().dump(*args, **kwargs)

    def to_dict(self):
        return convert_to_dict(self)

def convert_to_dict(cfg_node):
    if not isinstance(cfg_node, CfgNode):
        return cfg_node
    else:
        cfg_dict = dict(cfg_node)
        for k, v in cfg_dict.items():
            cfg_dict[k] = convert_to_dict(v)
        return cfg_dict

def sort_dict(obj):
    if isinstance(obj, list):
        return tuple(sorted(obj))
    elif isinstance(obj, dict):
        tolist = []
        for k in sorted(obj.keys()):
            tolist.append((k,sort_dict(obj[k])))
        return tuple(tolist)
    else:
        return obj